<h3 class="mb-3 fw-bold">Data Guru</h3>

<div class="card border-0 shadow-sm">
    <div class="card-body">

        <!-- Tombol Tambah -->
        <div class="mb-3">
            <button 
                class="btn btn-primary fw-bold"
                data-bs-toggle="modal"
                data-bs-target="#mGuru">
                <i class="bi bi-plus-lg me-1"></i> Tambah Guru
            </button>
        </div>

        <!-- Tabel Guru -->
        <table id="tabelGuru" class="table table-bordered table-hover w-100">
            <thead class="table-light">
                <tr>
                    <th>NIP</th>
                    <th>Nama</th>
                    <th>Mapel</th>
                    <th>Status</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $q = mysqli_query($koneksi, "SELECT * FROM guru");
                while ($d = mysqli_fetch_array($q)) {
                    $bg = ($d['status'] == 'Aktif') ? 'bg-success' : 'bg-secondary';
                ?>
                <tr>
                    <td><?= $d['nip']; ?></td>
                    <td><b><?= $d['nama']; ?></b></td>
                    <td><?= $d['mapel']; ?></td>
                    <td>
                        <span class="badge <?= $bg; ?>">
                            <?= $d['status']; ?>
                        </span>
                    </td>
                    <td class="text-center">
                        <a 
                            href="?page=edit_guru&id=<?= $d['id']; ?>" 
                            class="btn btn-sm btn-warning py-0">
                            Edit
                        </a>
                        <a 
                            href="?aksi=hapus_guru&id=<?= $d['id']; ?>" 
                            class="btn btn-sm btn-danger py-0"
                            onclick="return confirm('Hapus?')">
                            X
                        </a>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>

    </div>
</div>

<!-- Modal Tambah Guru -->
<div class="modal fade" id="mGuru">
    <div class="modal-dialog">
        <div class="modal-content">

            <form method="POST" action="proses/act_guru.php">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Guru</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">
                    <input 
                        type="text" 
                        name="nip" 
                        class="form-control mb-2" 
                        placeholder="NIP" 
                        required>

                    <input 
                        type="text" 
                        name="nama" 
                        class="form-control mb-2" 
                        placeholder="Nama" 
                        required>

                    <input 
                        type="text" 
                        name="mapel" 
                        class="form-control mb-2" 
                        placeholder="Mapel" 
                        required>

                    <select name="status" class="form-select">
                        <option value="Aktif">Aktif</option>
                        <option value="Pensiun">Pensiun</option>
                    </select>
                </div>

                <div class="modal-footer">
                    <button 
                        type="submit" 
                        name="simpan_guru" 
                        class="btn btn-primary">
                        Simpan
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>